﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PatientRelatedLabTests.aspx.cs" Inherits="PatientRelatedLabTests" %>

<%@ Register src="controls/RelatedLabDetails.ascx" tagname="RelatedLabDetails" tagprefix="UserControl" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text="Patients > Patient Lookup > Related Lab Tests > " />
    </div> 
    <asp:Panel runat="server" ID="PanelPatientInfo" GroupingText="&nbsp;Patient Information&nbsp;">
           <asp:Label SkinID="DataLabel" ID="LabelforLabelPatientName" 
            runat="server" AssociatedControlID="LabelPatientName" 
            ToolTip="Patient Name" >
            Patient Name:&nbsp;&nbsp;</asp:Label>
            <asp:Label SkinID="DataLabel" ID="LabelPatientName" 
            runat="server" ToolTip="Patient Name" >
            </asp:Label>
            <br />
            <asp:Label SkinID="DataLabel" ID="LabelforLabelPatientSnum" 
            runat="server" AssociatedControlID="LabelPatientSnum" 
            ToolTip="Patient SSN" >
            SSN:&nbsp;&nbsp;</asp:Label>
            <asp:Label SkinID="DataLabel" ID="LabelPatientSnum" 
            runat="server" ToolTip="Patient SSN" >
            </asp:Label>
   </asp:Panel>
   <br />
    <asp:Panel runat="server" ID="PanelRelatedLabTests" 
        GroupingText="&nbsp;Related Lab Tests&nbsp;">
    <asp:Repeater ID="RepeaterRelatedLabTests" runat="server"
         DataSourceID="ObjectDataSourceRelatedLabTests">
         <ItemTemplate>
            <table width="100%">
            <tr>
                <td width="50%">
                  <asp:Label SkinID="DataLabel" ID="LabelforLabelTestName" 
                    runat="server" AssociatedControlID="LabelTestName" 
                    ToolTip="Related Lab Test Name">
                    Test Name:&nbsp;&nbsp;</asp:Label>
                    <asp:Label SkinID="DataLabel" ID="LabelTestName" 
                    runat="server" ToolTip="Related Lab Test Name"
                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LabName")), false) %>' >
                    </asp:Label>
                </td>
                <td>
                   <asp:Label SkinID="DataLabel" ID="LabelforLabelSpecimenType" 
                    runat="server" AssociatedControlID="LabelSpecimenType" 
                    ToolTip="Specimen Type" >
                    SpecimenType:&nbsp;&nbsp;</asp:Label>
                    <asp:Label SkinID="DataLabel" ID="LabelSpecimenType" 
                    runat="server" ToolTip="Specimen Type"
                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("SpecimentType")), false) %>' >
                    </asp:Label>
               </td>
            </tr>
            <tr>
            <td colspan="2">
                <UserControl:RelatedLabDetails ID="RelatedLabDetails" runat="server"
                 PatientID='<%# Eval("PatientID") %>' LabName='<%# Eval("LabName") %>' SpecimenType='<%# Eval("SpecimentType") %>' />
            </td>
            </tr>
            </table>
            <br />
         </ItemTemplate>
         <FooterTemplate>
            <table runat="server" style="border: 3px solid grey" visible='<%# RepeaterRelatedLabTests.Items.Count == 0 %>'>
                 <tr>
                     <td>         
                     <asp:Label ID="lblEmptyData"
                            Text="No Records Available" runat="server" Visible='<%# RepeaterRelatedLabTests.Items.Count == 0 %>'>
                     </asp:Label>
                     </td> 
                 </tr>
             </table>           
         </FooterTemplate>
    </asp:Repeater>
    </asp:Panel>
    <asp:ObjectDataSource ID="ObjectDataSourceRelatedLabTests" runat="server" 
        SelectMethod="SelectRelatedLabTests" 
        TypeName="VeteransAffairs.Registries.BusinessManager.EFR.RelatedLabTestManager">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="PatientID" 
                QueryStringField="patientid" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <table width="100%"><tr><td align="left">
        <asp:Button runat = "server" Text = "Back" ID = "ButtonBack" Width = "130px" OnClick="ButtonBack_OnClick" UseSubmitBehavior = "false" />
   </td></tr></table> 
    <br />
    <br />
</asp:Content>

